package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Converts the body of a table.  Actually does practically nothing but call convert children, as the tr/td converters
 * do most of the work.
 */
final class TableBodyConverter implements Converter {
    static TableBodyConverter INSTANCE = new TableBodyConverter();

    private TableBodyConverter() {
    }

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.hasNodeName("tbody");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        NodeContext childConversionContext = new NodeContext.Builder(nodeContext)
                .ignoreText(true).previousSibling(null).build();
        return wysiwygConverter.convertChildren(childConversionContext);
    }
}
