package com.atlassian.renderer.wysiwyg.converter;

import com.atlassian.renderer.wysiwyg.NodeContext;

/**
 * Convert Font tags by converting their children.  Font tags are ignored, and handled the same way as
 * {@link com.atlassian.renderer.wysiwyg.converter.IgnoreNodeAndConvertChildText}.
 */
class FontConverter implements Converter {
    static final FontConverter INSTANCE = new FontConverter();

    public boolean canConvert(NodeContext nodeContext) {
        return nodeContext.getNode().getNodeName().equalsIgnoreCase("font");
    }

    public String convertNode(NodeContext nodeContext, DefaultWysiwygConverter wysiwygConverter) {
        NodeContext noIgnoreTextAndNoPreviousSibling =
                new NodeContext.Builder(nodeContext).ignoreText(false).previousSibling(null).build();
        return wysiwygConverter.convertChildren(noIgnoreTextAndNoPreviousSibling);
    }
}
