package com.atlassian.renderer.wysiwyg;

//todo (donw) before 5.0: Move this to the correct package.  (Not done yet due to disparate work on other checkout
public class WikiMarkupEscaper {
    /**
     * Escape any characters which would be interpreted as markup
     */
    private static String[] escapedCharactersRegex = new String[]{
            "(\\\\)?\\[",                               // (\\)?\[ - finds [ or \[
            "(\\\\)?\\]",                               // (\\)?\] - finds ] or \]
            "([^\\s])([\\*\\-\\+\\^~_](?:[\\s]|$))",    // ([^\s])([\*\-\+\^~_](?:[\s]|$)) - e.g. match foo* (but not foo*bar or *foo)
            "((?:^|[\\s]))([\\*\\-\\+\\^~_][^\\s])",    // ((?:^|[\s]))([\*\-\+\^~_][^\s]) - e.g. match *foo
            "(\\\\)?!",                                 // (\\)?! - finds ! or \!
        /*"\\{", "\\}",*/                           // todo check if we can put this back in
            "(\\\\)?\\|",                               // (\\)?\| - finds | or \|
            "(^\\s*)([\\*\\#\\-])"                      // (^\s*)([\*\#\-]) - e.g. match "#" or " -" (but not "foo*")
    };
    private static String[] escapedCharactersReplacement = new String[]{
            "\\\\[",                                    // replace with \[
            "\\\\]",                                    // replace with \]
            "$1\\\\$2",                                 // replace foo* with foo\*
            "$1\\\\$2",                                 // replace *foo with \*foo
            "\\\\!",                                    // replace with \!
        /*"\\\\{", "\\\\}",*/
            "\\\\|",                                    // replace with \|
            "$1\\\\$2"                                  // replace #Noob with \#Noob, or " *Bee" with " \*Bee"
    };


    public static String escapeWikiMarkup(String s) {
        for (int i = 0; i < escapedCharactersRegex.length; ++i) {
            s = s.replaceAll(escapedCharactersRegex[i], escapedCharactersReplacement[i]);
        }
        return s;
    }
}
