package com.atlassian.renderer.v2.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.Renderer;
import com.atlassian.renderer.v2.V2Renderer;

/**
 * A V2Renderer that gets its components from the plugin system
 */
public class PluggableV2Renderer implements Renderer {
    private final RendererComponentsAccessor rendererComponentsAccessor;

    /**
     * Construct a new pluggable V2Renderer
     *
     * @param pluginAccessor the plugin accessor
     */
    public PluggableV2Renderer(PluginAccessor pluginAccessor) {
        this.rendererComponentsAccessor = new RendererComponentsAccessor(pluginAccessor);
    }

    /**
     * @see Renderer#render
     */
    public String render(String originalContent, RenderContext renderContext) {
        return getRenderer().render(originalContent, renderContext);
    }

    /**
     * @see Renderer#renderAsText
     */
    public String renderAsText(String originalContent, RenderContext context) {
        return getRenderer().renderAsText(originalContent, context);
    }

    /**
     * This renderer identifies as a V2Renderer.
     *
     * @return V2Renderer.RENDERER_TYPE
     */
    public String getRendererType() {
        return V2Renderer.RENDERER_TYPE;
    }

    private V2Renderer getRenderer() {
        return new V2Renderer(rendererComponentsAccessor.getActiveRendererComponents());
    }
}
