package com.atlassian.renderer.v2.macro.code.formatter;

public class RFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "FALSE", "Inf", "NA", "NA_character_", "NA_complex_", "NA_integer_", "NA_real_", "NULL",
            "NaN", "TRUE", "break", "else", "for", "function", "if", "in", "next", "repeat", "while"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "character", "complex", "integer", "logical", "numeric", "raw"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"r"};

    public RFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(HASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}