package com.atlassian.renderer.v2.macro.code.formatter;

public class LuaFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in",
            "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "nil", "boolean", "number", "string", "function", "userdata", "thread", "table"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"lua"};

    public LuaFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(DASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}