package com.atlassian.renderer.v2.macro.code.formatter;

public class JavaFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "abstract", "assert", "break", "byvalue", "case", "cast", "catch", CLASS, "const",
            "continue", "default", "do", "else", "enum", "extends", "false", "final", "finally",
            "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof",
            "interface", "native", "new", "null", "operator", "outer", "package", "private",
            "protected", "public", "rest", "return", "static", "super", "switch", "synchronized",
            "this", "throw", "throws", "transient", "true", "try", "var", "volatile", "while"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "Boolean", "Byte", "Character", "Class", "ClassLoader", "Cloneable", "Compiler", "Double",
            "Float", "Integer", "Long", "Math", "Number", "Object", "Process", "Runnable", "Runtime",
            "SecurityManager", "Short", "String", "StringBuffer", "System", "Thread", "ThreadGroup",
            "Void", "boolean", "char", "byte", "short", "int", "long", "float", "double"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"java"};

    public JavaFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SLASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(C_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}
