package com.atlassian.renderer.v2.macro.code.formatter;

public class HaskellFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "as", "case", CLASS, "data", "data", "default", "deriving", "do", "else", "false", "family",
            "forall", "foreign", "hiding", "if", "import", "in", "infix", "infixl", "infixr", "instance",
            "let", "mdo", "module", "newtype", "of", "proc", "qualified", "rec", "then", "true", "type",
            "where"
    });

    private static final String OBJECTS = individualWords(new String[]{
            "Bool", "Bounded", "Either", "Enum", "Eq", "Floating", "Fractional", "Functor", "IO",
            "Integral", "Maybe", "Monad", "MonadPlus", "Num", "Ord", "Ordering", "Read", "Real",
            "RealFloat", "RealFrac", "Show", "String"
    });

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"haskell"};

    public HaskellFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT);
        addReplacement(DASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(KEYWORDS, KEYWORD_REPLACEMENT);
        addReplacement(OBJECTS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}