package com.atlassian.renderer.v2.macro.code.formatter;

public class BashFormatter extends AbstractFormatter {
    private static final String KEYWORDS = individualWords(new String[]{
            "case", "do", "done", "elif", "else", "esac", "fi", "for", "function", "if", "in",
            "local", "select", "then", "time", "until", "while"
    });

    private static final String SYMBOLS = individualWords(new String[]{
            "-eq", "-ne", "-gt", "-ge", "-lt", "-le"
    });

    private static final String VARIABLES = "(\\$[a-zA-Z0-9]+)\\b";

    private static final String[] SUPPORTED_LANGUAGES = new String[]{"sh", "bash"};

    public BashFormatter() {
        addReplacement(DQUOTES, QUOTES_REPLACEMENT_RED);
        addReplacement(SQUOTES, QUOTES_REPLACEMENT_RED);
        addReplacement(HASH_COMMENTS, COMMENTS_REPLACEMENT);
        addReplacement(SYMBOLS, OBJECT_REPLACEMENT);
        addReplacement(VARIABLES, OBJECT_REPLACEMENT);
        addReplacement(KEYWORDS, OBJECT_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}