package com.atlassian.renderer.v2.macro;

/**
 * There are two ways that a Macro Body can be rendered for a Wysiwyg editor.
 * The default way is to interpret the body as wiki markup and render it to Xhtml like it would
 * any other wiki markup.  The other is to interpret it as plain text and escape it displays
 * exactly as-is.  Such text is wrapped in a preformat block to preserve newlines
 * and multiple spaces.
 */
public enum WysiwygBodyType {
    /**
     * Body is wiki markup and should be rendered to html.
     */
    WIKI_MARKUP,
    /**
     * Body is not wiki markup and should only have html characters escaped.
     */
    PREFORMAT
}
