package com.atlassian.renderer.v2.macro;

import com.atlassian.renderer.v2.V2SubRenderer;
import com.atlassian.renderer.v2.macro.basic.BasicAnchorMacro;
import com.atlassian.renderer.v2.macro.basic.ColorMacro;
import com.atlassian.renderer.v2.macro.basic.InlineHtmlMacro;
import com.atlassian.renderer.v2.macro.basic.LoremIpsumMacro;
import com.atlassian.renderer.v2.macro.basic.NoformatMacro;
import com.atlassian.renderer.v2.macro.basic.PanelMacro;
import com.atlassian.renderer.v2.macro.basic.QuoteMacro;
import com.atlassian.renderer.v2.macro.code.CodeMacro;
import com.atlassian.renderer.v2.macro.code.SourceCodeFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.ActionScriptFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.AdaFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.ApplescriptFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.BashFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.CSharpFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.CppFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.CssFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.ErlangFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.GoFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.GroovyFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.HaskellFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.JavaFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.JavaScriptFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.LuaFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.NoneFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.ObjectiveCFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.PerlFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.PhpFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.PythonFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.RFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.RainbowFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.RubyFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.ScalaFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.SqlFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.SwiftFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.VisualBasicFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.XmlFormatter;
import com.atlassian.renderer.v2.macro.code.formatter.YamlFormatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * A simple hard-coded implementation of a MacroManager that will server up the basic
 * and html macros included in the renderer component.
 */
public class DefaultMacroManager implements MacroManager {
    private HashMap<String, Macro> macros;

    public DefaultMacroManager(V2SubRenderer subRenderer) {
        macros = new HashMap<String, Macro>();
        macros.put("anchor", new BasicAnchorMacro());
        macros.put("code", new CodeMacro(subRenderer, getCodeFormatters()));
        macros.put("quote", new QuoteMacro());
        macros.put("noformat", new NoformatMacro(subRenderer));
        macros.put("panel", new PanelMacro(subRenderer));
        macros.put("color", new ColorMacro());
        macros.put("loremipsum", new LoremIpsumMacro());
        macros.put("html", new InlineHtmlMacro());
    }

    public void registerMacro(String name, Macro macro) {
        macros.put(name, macro);
    }

    private List<SourceCodeFormatter> getCodeFormatters() {
        List<SourceCodeFormatter> codeFormatters = new ArrayList<SourceCodeFormatter>();
        codeFormatters.add(new NoneFormatter());
        codeFormatters.add(new ActionScriptFormatter());
        codeFormatters.add(new AdaFormatter());
        codeFormatters.add(new ApplescriptFormatter());
        codeFormatters.add(new BashFormatter());
        codeFormatters.add(new CSharpFormatter());
        codeFormatters.add(new CppFormatter());
        codeFormatters.add(new CssFormatter());
        codeFormatters.add(new ErlangFormatter());
        codeFormatters.add(new GoFormatter());
        codeFormatters.add(new GroovyFormatter());
        codeFormatters.add(new HaskellFormatter());
        codeFormatters.add(new JavaFormatter());
        codeFormatters.add(new JavaScriptFormatter());
        codeFormatters.add(new LuaFormatter());
        codeFormatters.add(new ObjectiveCFormatter());
        codeFormatters.add(new PerlFormatter());
        codeFormatters.add(new PhpFormatter());
        codeFormatters.add(new PythonFormatter());
        codeFormatters.add(new RainbowFormatter());
        codeFormatters.add(new RFormatter());
        codeFormatters.add(new RubyFormatter());
        codeFormatters.add(new ScalaFormatter());
        codeFormatters.add(new SqlFormatter());
        codeFormatters.add(new SwiftFormatter());
        codeFormatters.add(new VisualBasicFormatter());
        codeFormatters.add(new XmlFormatter());
        codeFormatters.add(new YamlFormatter());
        return codeFormatters;
    }

    public Macro getEnabledMacro(String name) {
        return macros.get(name);
    }

    public void unregisterMacro(String name) {
        macros.remove(name);
    }
}
