package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;

public class HtmlEscapeRendererComponent implements RendererComponent {

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.htmlEscape();
    }

    public String render(String wiki, RenderContext context) {
        return HtmlEscaper.escapeAllExceptQuotes(wiki, context.getRenderMode().preserveEntities());
    }

    /**
     * Escapes HTML
     *
     * @see HtmlEscaper
     * @deprecated since 3.12 see {@link HtmlEscaper#escapeAllExceptQuotes(String, boolean)}
     */
    public static String escapeHtml(String s, boolean preserveExistingEntities) {
        return HtmlEscaper.escapeAllExceptQuotes(s, preserveExistingEntities);
    }

}
