package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * RAID-761
 * Omits conversion if token is present - it effectively forbids token nesting
 */
public abstract class AbstractNoTokenRegexRendererComponent extends AbstractRegexRendererComponent {
	/**
	 * This regexRender is almost same as parents one.
	 * Just appendSubstitution is replaced by appendNoTokenSubstitution.
	 */
	protected String regexRender(String wiki, RenderContext context, Pattern pattern) {
		if (wiki == null || wiki.length() == 0) {
			return "";
		}

		final Matcher matcher = pattern.matcher(wiki);
		if (!matcher.find()) {
			return wiki;
		}

		final StringBuffer buffer = new StringBuffer();
		int mark = 0;
		do {
			buffer.append(wiki, mark, matcher.start());
			mark = matcher.end();
			appendNoTokenSubstitution(buffer, context, matcher);
		}
		while (matcher.find());

		return buffer.append(wiki, mark, wiki.length()).toString();
	}

	/**
	 *  In some renderers resolving tokens in tokens should be forbidden but sometimes occur and causes XSS and garbage.
	 *  This renderer only appends substitution if rendered part doesn't contain token in it.
	 *
	 */
	private void appendNoTokenSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
		String match = matcher.group();
		if (containsToken(match)) {
			buffer.append(match);
		} else {
			appendSubstitution(buffer, context, matcher);
		}
	}

	private boolean containsToken(String chunk) {
		for (TokenType tokenType : TokenType.values()) {
			Matcher m = tokenType.getTokenPattern().matcher(chunk);
			if (m.find()) {
				return true;
			}
		}
		return false;
	}
}