package com.atlassian.renderer.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachmentManager;

import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: Jeremy Higgs
 * Date: 22/09/2005
 * Time: 09:47:49
 */

public class EmbeddedFlashRenderer extends EmbeddedObjectRenderer implements EmbeddedResourceRenderer {
    public static final String DISPLAY_INLINE_PARAMETER_NAME = "displayInline";

    public EmbeddedFlashRenderer(RendererAttachmentManager attachmentManager) {
        super(attachmentManager);
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        // Setup the properties and fetch the object URL
        Map contextMap = setupObjectProperties(resource, context);

        // In Flash Player 10, setting Content-Disposition to attachment causes Flash Player to silently not play the
        // file. So we insert a parameter here that can be picked up later to not set this header when rendering
        // an embedded flash resource.

        String source = (String) contextMap.get("src");
        if (source != null) {
            contextMap.put("src", source + "?" + DISPLAY_INLINE_PARAMETER_NAME + "=true");
        }
        if (contextMap.get("data") != null) {
            contextMap.put("data", contextMap.get("data") + "?" + DISPLAY_INLINE_PARAMETER_NAME + "=true");
        }
        if (contextMap.get("object") != null) {
            contextMap.put("object", contextMap.get("object") + "?" + DISPLAY_INLINE_PARAMETER_NAME + "=true");
        }

        // Flash-specific stuff
        if (contextMap.get("movie") == null) {
            contextMap.put("movie", contextMap.get("object"));
        } else {
            contextMap.put("movie", contextMap.get("movie") + "?" + DISPLAY_INLINE_PARAMETER_NAME + "=true");
        }

        //For some reason, this causes FP9 to blow up
        contextMap.remove("loop");

        String renderedObjectHtml = renderEmbeddedObject(contextMap);

        return renderEmbeddedObjectWrapper(renderedObjectHtml, contextMap);
    }
}
