/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.Renderable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;

public class RenderedContentStore {
    private static Category log = Category.getInstance(RenderedContentStore.class);
    public static final String BLOCK_TOKEN = TokenType.BLOCK.getTokenMarker();
    public static final String INLINE_TOKEN = TokenType.INLINE.getTokenMarker();
    public static final String MAP_KEY = "RenderedContentStore";
    private List<Object> store = new ArrayList<Object>();

    public static RenderedContentStore getFromRenderContext(RenderContext renderContext) {
        return renderContext.getRenderedContentStore();
    }

    public String addContent(Object content, TokenType type) {
        if (!(content instanceof String) && !(content instanceof Renderable)) {
            throw new RuntimeException("You can only store String and Renderable objects.");
        }
        this.store.add(content);
        return type.getTokenMarker() + (this.store.size() - 1) + type.getTokenMarker();
    }

    public String addBlock(Object content) {
        return this.addContent(content, TokenType.BLOCK);
    }

    public String addInline(Object content) {
        return this.addContent(content, TokenType.INLINE);
    }

    public Object get(String token) {
        try {
            if (token == null || token.length() < 3) {
                log.warn((Object)"Could not find stored token: the token was null or too short. A filter or macro may be broken.");
                return null;
            }
            int len = TokenType.BLOCK.getTokenMarker().length();
            int id = Integer.parseInt(token.substring(len, token.length() - len));
            return this.store.get(id);
        }
        catch (Exception e) {
            log.warn((Object)("Could not find stored token. A filter or macro may be broken. Exception: " + e.getMessage()));
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderedContentStore)) {
            return false;
        }
        RenderedContentStore renderedContentStore = (RenderedContentStore)o;
        return this.store == null ? renderedContentStore.store == null : this.store.equals(renderedContentStore.store);
    }

    public int hashCode() {
        return this.store != null ? this.store.hashCode() : 0;
    }

    public static String stripTokens(String text) {
        for (TokenType tokenType : TokenType.values()) {
            text = tokenType.getTokenDeleteReplacer().replaceAllSkippingConstantsCheck(text);
        }
        return text;
    }
}

