/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class CppFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = CppFormatter.individualWords(new String[]{"alignas", "alignof", "and", "and_eq", "asm", "atomic_cancel", "atomic_commit", "atomic_noexcept", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class[^=]", "compl", "concept", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "[^#]if", "import", "inline", "int", "long", "module", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "NULL", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "restrict", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "std", "struct", "switch", "synchronized", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq", "override", "final", "transaction_safe", "transaction_safe_dynamic"});
    private static final String OBJECTS = CppFormatter.individualWords(new String[]{"bool", "char", "double", "float", "int", "long", "short", "signed", "uintptr_t", "unsigned", "void", "wchar_t"});
    private static final String ANGLED = "(\\&lt;)(.+?)(?<!(\\&gt;))(\\&gt;)";
    private static final String PREPROCESSOR_DIRECTIVES = "#(.*?)($|\r?\n)";
    private static final String PREPROCESSOR_REPLACEMENT = "<span class=\"code-macro\">$0</span>";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"c", "cpp", "c++"};

    public CppFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement(ANGLED, "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(PREPROCESSOR_DIRECTIVES, PREPROCESSOR_REPLACEMENT);
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

