/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class ActionScriptFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = ActionScriptFormatter.individualWords(new String[]{"break", "call", "chr", "continue", "delete", "do", "duplicateMovieClip", "else", "escape", "eval", "for", "fscommand", "function", "getProperty", "getTimer", "getURL", "getVersion", "gotoAndPlay", "gotoAndStop", "if", "ifFrameLoaded", "in", "int", "isFinite", "isNaN", "length", "loadMo", "vie", "loadVariables", "maxscroll", "mbchr", "mblength", "mbord", "mbsubstring", "NaN", "new", "newline", "nextFrame", "nextScene", "null", "o", "ClipEvent", "load", "unload", "enterFrame", "mouseMove", "mouseDown", "mouseUp", "keyDown", "keyUp", "data", "on", "press", "release", "releas", "Outside", "rollOver", "rollOut", "dragOver", "dragOut", "keyPress", "ord", "parseFloat", "parseInt", "play", "prevFrame", "prevScene", "pri", "t", "printAsBitmap", "random", "removeMovieClip", "return", "scroll", "set", "setProperty", "startDrag", "stop", "stopAllSounds", "stopD", "ag", "substring", "targetPath", "tellTarget", "this", "toggleHighQuality", "trace", "typeof", "unescape", "unloadMovie", "updateAfter", "Event", "var", "void", "while", "with"});
    private static final String OBJECTS = ActionScriptFormatter.individualWords(new String[]{"Array", "Boolean", "Color", "Date", "Infinity", "Key", "Math", "Mouse", "MovieClip", "Number", "Object", "Selection", "Sound", "String", "XML", "XMLSocket"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"actionscript"};

    public ActionScriptFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

