/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackslashEscapeRendererComponent
extends AbstractRegexRendererComponent {
    private static final Pattern ESCAPING_PATTERN = Pattern.compile("(^|(?<!\\\\))\\\\([\\-\\#\\*\\_\\+\\?\\^\\~\\|\\%\\{\\}\\[\\]\\(\\)\\!\\@])");

    public static String escapeWiki(String str) {
        int i = BackslashEscapeRendererComponent.findNextSpecialChar(str, 0);
        if (i == -1) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 10);
        int mark = 0;
        do {
            sb.append(str, mark, i).append('\\');
            mark = i;
        } while ((i = BackslashEscapeRendererComponent.findNextSpecialChar(str, i + 1)) != -1);
        return sb.append(str, mark, len).toString();
    }

    private static int findNextSpecialChar(String str, int index) {
        int len = str.length();
        while (index < len) {
            if (BackslashEscapeRendererComponent.isSpecial(str.charAt(index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '^': 
            case '_': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.backslashEscape();
    }

    @Override
    public String render(String wiki, RenderContext context) {
        return wiki.indexOf(92) == -1 ? wiki : this.regexRender(wiki, context, ESCAPING_PATTERN);
    }

    @Override
    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        char c = matcher.group(2).charAt(0);
        switch (c) {
            case '[': 
            case ']': {
                buffer.append(c);
                return;
            }
            case '{': 
            case '}': {
                if (context.isRenderingForWysiwyg()) {
                    buffer.append(context.getRenderedContentStore().addInline("\\" + c));
                    return;
                }
                buffer.append(c);
                return;
            }
        }
        buffer.append("&#").append((int)c).append(';');
    }
}

