/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.renderer.v2.components.link.LinkDecorator;

public class LinkRendererComponent
implements RendererComponent {
    private LinkResolver linkResolver;
    public static final char START_LINK_CHAR = '[';
    private static final char ESCAPE_CHAR = '\\';
    private static final char END_LINK_CHAR = ']';
    private static final char NEW_LINE_CHAR = '\n';

    public LinkRendererComponent(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    @Override
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinks();
    }

    @Override
    public String render(String wiki, RenderContext context) {
        int end;
        if (wiki == null || wiki.length() < 3) {
            return wiki;
        }
        int start = LinkRendererComponent.findLinkStart(wiki, 0);
        while (start != -1 && (end = LinkRendererComponent.findLinkEnd(wiki, start)) != 0) {
            if (end < 0) {
                start = LinkRendererComponent.findLinkStart(wiki, -end);
                continue;
            }
            return this.renderHeavy(wiki, context, start, end);
        }
        return wiki;
    }

    private String renderHeavy(String wiki, RenderContext context, int start, int end) {
        int len = wiki.length();
        StringBuilder sb = new StringBuilder(len / 2 * 3 + 1);
        sb.append(wiki, 0, start);
        this.appendLink(sb, context, wiki.substring(start + 1, end));
        int mark = end + 1;
        start = LinkRendererComponent.findLinkStart(wiki, mark);
        while (start != -1 && (end = LinkRendererComponent.findLinkEnd(wiki, start)) != 0) {
            if (end < 0) {
                start = LinkRendererComponent.findLinkStart(wiki, -end);
                continue;
            }
            sb.append(wiki, mark, start);
            this.appendLink(sb, context, wiki.substring(start + 1, end));
            mark = end + 1;
            start = LinkRendererComponent.findLinkStart(wiki, mark);
        }
        return sb.append(wiki, mark, len).toString();
    }

    private void appendLink(StringBuilder stringBuffer, RenderContext context, String linkText) {
        Link link = this.linkResolver.createLink(context, linkText);
        stringBuffer.append(context.getRenderedContentStore().addInline(new LinkDecorator(link)));
    }

    private static int findLinkStart(String wiki, int startIndex) {
        int len = wiki.length();
        int index = wiki.indexOf(91, startIndex);
        while (index != -1) {
            if (index <= 0 || wiki.charAt(index - 1) != '\\') {
                int nextIndex = index + 1;
                if (nextIndex == len) {
                    return -1;
                }
                char nextChar = wiki.charAt(nextIndex);
                if (nextChar != ']' && !Character.isWhitespace(nextChar)) break;
            }
            index = wiki.indexOf(91, index + 1);
        }
        return index;
    }

    private static int findLinkEnd(String wiki, int startIndex) {
        int len = wiki.length();
        char prev = '\u0000';
        for (int index = startIndex + 1; index < len; ++index) {
            char c = wiki.charAt(index);
            switch (c) {
                case ']': {
                    if (prev == '\\') break;
                    return index;
                }
                case '[': {
                    if (prev == '\\') break;
                    return -index;
                }
                case '\n': {
                    return -(index + 1);
                }
            }
            prev = c;
        }
        return 0;
    }
}

