/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.table;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.SubRenderer;

public class TableCell
implements Renderable {
    private final String content;
    private boolean header;

    public TableCell(String content) {
        this(content, false);
    }

    public TableCell(String content, boolean header) {
        this.content = content;
        this.header = header;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void render(SubRenderer subRenderer, RenderContext context, StringBuffer buff) {
        String renderedContent = null;
        renderedContent = this.content.trim().length() == 0 ? this.content : subRenderer.render(this.content, context, RenderMode.TABLE_CELL);
        if (RenderUtils.isBlank(renderedContent)) {
            renderedContent = "&nbsp;";
        }
        if (this.isHeader()) {
            buff.append("<th class='confluenceTh'>").append(renderedContent).append("</th>");
        } else {
            buff.append("<td class='confluenceTd'>").append(renderedContent).append("</td>");
        }
        buff.append("\n");
    }

    public String toString() {
        return "|" + (this.header ? "|" : "") + this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableCell)) {
            return false;
        }
        TableCell tableCell = (TableCell)o;
        if (this.header != tableCell.header) {
            return false;
        }
        return !(this.content != null ? !this.content.equals(tableCell.content) : tableCell.content != null);
    }

    public int hashCode() {
        int result = this.content != null ? this.content.hashCode() : 0;
        result = 29 * result + (this.header ? 1 : 0);
        return result;
    }
}

