/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.basic;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.basic.validator.ColorStyleValidator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ColorMacro
extends BaseMacro {
    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.INLINE.or(RenderMode.allow(4L));
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String color = StringUtils.trimToEmpty((String)((String)parameters.get("0")));
        new ColorStyleValidator().assertValid(color);
        return "<font color=\"" + color + "\">" + body + "</font>";
    }

    public boolean suppressSurroundingTagDuringWysiwygRendering() {
        return true;
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return false;
    }
}

