/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.phrase;

import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.util.RegExpUtil;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmoticonRendererComponent
extends AbstractRegexRendererComponent {
    private IconManager iconManager;
    private Pattern[] emoticonPatterns;
    private String[] emoticonSymbols;

    public EmoticonRendererComponent(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderPhrases();
    }

    public String render(String wiki, RenderContext context) {
        Pattern[] patterns = this.getEmoticonPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            if (wiki.indexOf(this.emoticonSymbols[i]) == -1) continue;
            Pattern pattern = patterns[i];
            wiki = this.regexRender(wiki, context, pattern);
        }
        return wiki;
    }

    private Pattern[] getEmoticonPatterns() {
        if (this.emoticonPatterns == null) {
            String[] emoticons = this.iconManager.getEmoticonSymbols();
            this.emoticonPatterns = new Pattern[emoticons.length];
            this.emoticonSymbols = new String[emoticons.length];
            for (int i = 0; i < emoticons.length; ++i) {
                String symbol = emoticons[i];
                String patternString = "(" + RegExpUtil.convertToRegularExpression(symbol) + ")($|(?![a-zA-Z]))";
                if (symbol.startsWith(";")) {
                    patternString = "(^|(?<!\\&#?[a-zA-Z0-9]{1,10}))" + patternString;
                }
                this.emoticonPatterns[i] = Pattern.compile(patternString);
                this.emoticonSymbols[i] = symbol;
            }
        }
        return this.emoticonPatterns;
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        String symbol = matcher.group(1);
        if (matcher.groupCount() == 3) {
            symbol = matcher.group(2);
        }
        buffer.append(this.iconManager.getEmoticon(symbol).toHtml(context.getImagePath()));
    }
}

