/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2;

import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.components.WikiContentHandler;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroManager;

public class WikiMarkupParser {
    WikiContentHandler wikiContentHandler;
    private MacroManager macroManager;

    public WikiMarkupParser(MacroManager macroManager, WikiContentHandler wikiContentHandler) {
        this.wikiContentHandler = wikiContentHandler;
        this.macroManager = macroManager;
    }

    public String parse(String wiki) {
        StringBuffer out = new StringBuffer(wiki.length());
        if (wiki.indexOf("{") == -1) {
            this.wikiContentHandler.handleText(out, wiki);
            return out.toString();
        }
        int lastStart = 0;
        boolean inEscape = false;
        for (int i = 0; i < wiki.length(); ++i) {
            char c = wiki.charAt(i);
            if (!inEscape) {
                switch (c) {
                    case '\\': {
                        inEscape = true;
                        break;
                    }
                    case '{': {
                        if (wiki.length() > i + 1 && "{*?^_-+~".indexOf(wiki.charAt(i + 1)) != -1) {
                            ++i;
                            break;
                        }
                        this.wikiContentHandler.handleText(out, wiki.substring(lastStart, i));
                        lastStart = i + 1;
                        i = this.handlePotentialMacro(wiki, i, out);
                        lastStart = i + 1;
                    }
                }
                continue;
            }
            inEscape = false;
        }
        if (lastStart < wiki.length()) {
            this.wikiContentHandler.handleText(out, wiki.substring(lastStart));
        }
        return out.toString();
    }

    private int handlePotentialMacro(String wiki, int i, StringBuffer out) {
        MacroTag startTag = MacroTag.makeMacroTag(wiki, i);
        if (startTag != null) {
            Macro macro = this.getMacroByName(startTag.command);
            int endTagOffset = 0;
            if (macro == null || macro.hasBody()) {
                endTagOffset = this.findEndTagOffset(wiki, startTag);
            }
            if (endTagOffset > 0) {
                this.makeMacro(out, wiki, startTag, endTagOffset);
                i = endTagOffset + startTag.command.length() + 1;
            } else {
                this.makeMacro(out, startTag);
                i = startTag.endIndex;
            }
        } else {
            out.append('{');
        }
        return i;
    }

    private void makeMacro(StringBuffer buffer, MacroTag startTag) {
        this.makeMacro(buffer, startTag, "", false);
    }

    private void makeMacro(StringBuffer buffer, String wiki, MacroTag startTag, int endTagOffset) {
        String body = wiki.substring(startTag.endIndex + 1, endTagOffset);
        boolean hasEndTag = endTagOffset > 0;
        this.makeMacro(buffer, startTag, body, hasEndTag);
    }

    private void makeMacro(StringBuffer buffer, MacroTag startTag, String body, boolean hasEndTag) {
        this.wikiContentHandler.handleMacro(buffer, startTag, body, hasEndTag);
    }

    private Macro getMacroByName(String name) {
        if (name == null) {
            return null;
        }
        return this.macroManager.getEnabledMacro(name.toLowerCase());
    }

    private int findEndTagOffset(String wiki, MacroTag startTag) {
        boolean inEscape = false;
        for (int i = startTag.startIndex + startTag.originalText.length(); i < wiki.length(); ++i) {
            char c = wiki.charAt(i);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '{') {
                MacroTag endTag = MacroTag.makeMacroTag(wiki, i);
                if (endTag == null || !startTag.command.equals(endTag.command) || endTag.argString.length() != 0) continue;
                return i;
            }
            if (c != '\\') continue;
            inEscape = true;
        }
        return 0;
    }
}

