/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.util;

import java.util.regex.Pattern;

public class RenderedContentToken {
    private static final String PREFIX = "\u0001tok";
    private final String string;
    private final Pattern pattern;
    private final String token;

    public static int getIndex(String token) throws NumberFormatException, StringIndexOutOfBoundsException {
        int length = PREFIX.length();
        int separatorIndex = token.indexOf("-");
        String substring = token.substring(length, separatorIndex);
        return Integer.parseInt(substring);
    }

    public RenderedContentToken(String token) {
        this.string = "\u0001tok\\d+-" + token + "-tok\u0002";
        this.pattern = Pattern.compile(this.string, 128);
        this.token = token;
    }

    public String token(int index) {
        return PREFIX + index + "-" + this.token + "-tok\u0002";
    }

    public String getString() {
        return this.string;
    }

    public boolean matches(CharSequence input) {
        return this.pattern.matcher(input).find();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.getString();
    }

    private static final class Annotation {
        private static final String TOKEN_ID = "tok";
        static final String ANCHOR = "\u0001tok";
        static final String SEPARATOR = "-";
        static final String TERMINATOR = "-tok\u0002";

        private Annotation() {
        }
    }
}

