/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.wysiwyg;

import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.opensymphony.util.TextUtils;
import org.w3c.dom.Node;

public class WysiwygLinkHelper {
    public static String getLinkInfoAttributes(Link link) {
        return "linktype=\"raw\" linktext=\"" + TextUtils.htmlEncode((String)link.getOriginalLinkText()) + "\"" + (link instanceof UnpermittedLink || link instanceof UnresolvedLink ? " class=\"linkerror\"" : "");
    }

    public static String createLinkWikiText(Node node, String alias, String aliasUnformatted) {
        if (alias.startsWith("TEXTSEP")) {
            alias = alias.substring("TEXTSEP".length());
        }
        String linkType = node.getAttributes().getNamedItem("linktype").getNodeValue();
        String linkText = node.getAttributes().getNamedItem("linktext").getNodeValue();
        if (linkText.startsWith("mailto:")) {
            aliasUnformatted = "mailto:" + aliasUnformatted;
        }
        if (linkText.startsWith("#") && !aliasUnformatted.startsWith("#")) {
            aliasUnformatted = "#" + aliasUnformatted;
        }
        if (linkText.startsWith("^") && !aliasUnformatted.startsWith("^")) {
            aliasUnformatted = "^" + aliasUnformatted;
        }
        if (linkText.startsWith("~") && !aliasUnformatted.startsWith("~") || WysiwygLinkHelper.isShortcutLink(linkText)) {
            aliasUnformatted = linkText;
        }
        alias = alias.trim();
        if (linkType.equals("raw")) {
            String linkTextWithoutAlias = linkText;
            if (linkTextWithoutAlias.indexOf(alias) == 0) {
                linkTextWithoutAlias = linkTextWithoutAlias.substring(alias.length());
            }
            String[] components = linkTextWithoutAlias.split("\\|");
            StringBuffer linkBody = new StringBuffer("[");
            if (components.length == 1) {
                linkBody.append(aliasUnformatted);
            } else if (components.length == 2) {
                if (WysiwygLinkHelper.stringEqualsStringMinusPrefix(alias, components[1], new String[]{"mailto:", "#", "^"})) {
                    linkBody.append(components[1]);
                } else {
                    linkBody.append(alias).append("|").append(components[1]);
                }
            } else if (components.length == 3) {
                linkBody.append(alias).append("|").append(components[1]).append("|").append(components[2]);
            }
            return linkBody.append("]").toString();
        }
        return "";
    }

    public static boolean isShortcutLink(String linkText) {
        return linkText.indexOf(64) != -1;
    }

    private static boolean stringEqualsStringMinusPrefix(String s1, String s2, String[] prefixes) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!s2.equals(prefixes[i] + s1)) continue;
            return true;
        }
        return false;
    }
}

