/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.scheduler;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public final class SchedulerServiceTest
extends SpringAwareTestCase {
    private SchedulerService schedulerService;
    private final JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"test-job-runner");

    @Test
    public void testSchedulerServiceJob() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.schedulerService.registerJobRunner(this.jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                latch.countDown();
                return null;
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)this.jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce(null));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
        }
        catch (SchedulerServiceException sse) {
            throw new SchedulerRuntimeException(sse.getMessage(), (Throwable)sse);
        }
        MatcherAssert.assertThat((Object)latch.await(30L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

