/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.oauth;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.sal.api.ApplicationProperties;
import java.net.URI;
import java.security.PublicKey;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ServiceProviderConsumerStoreTest
extends SpringAwareTestCase {
    private static final String CONSUMER_KEY = "test-consumer";
    private static final String CONSUMER_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxZDzGUGk6rElyPm0iOua0lWg84nOlhQN1gmTFTIu5WFyQFHZF6OA4HX7xATttQZ6N21yKMakuNdRvEudyN/coUqe89r3Ae+rkEIn4tCxGpJWX205xVF3Cgsn8ICj6dLUFQPiWXouoZ7HG0sPKhCLXXOvUXmekivtyx4bxVFD9Zy4SQ7IHTx0V0pZYGc6r1gF0LqRmGVQDaQSbivigH4mlVwoAO9Tfccf+V00hYuSvntU+B1ZygMw2rAFLezJmnftTxPuehqWu9xS5NVsPsWgBL7LOi3oY8lhzOYjbMKDWM6zUtpOmWJA52cVJW6zwxCxE28/592IARxlJcq14tjwYwIDAQAB";
    private ServiceProviderConsumerStore consumerStore;
    private ApplicationProperties appProp;

    public void setConsumerStore(ServiceProviderConsumerStore consumerStore) {
        this.consumerStore = consumerStore;
    }

    public void setAppProp(ApplicationProperties appProp) {
        this.appProp = appProp;
    }

    @Test
    public void testServiceProviderConsumerStoreIsAvailable() {
        Assert.assertNotNull((String)"ServiceProviderConsumerStore must be available to plugins", (Object)this.consumerStore);
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreConfiguration() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertEquals((Object)CONSUMER_KEY, (Object)savedConsumer.getKey());
        Assert.assertEquals((Object)"Test Consumer Name", (Object)savedConsumer.getName());
        Assert.assertEquals((Object)publicKey, (Object)savedConsumer.getPublicKey());
        Assert.assertEquals((Object)"Consumer Description", (Object)savedConsumer.getDescription());
        Assert.assertEquals((Object)URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1"), (Object)savedConsumer.getCallback());
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreOAuth2LOConfiguration() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).twoLOAllowed(true).executingTwoLOUser("2lo_user").build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertTrue((boolean)savedConsumer.getTwoLOAllowed());
        Assert.assertEquals((Object)"2lo_user", (Object)savedConsumer.getExecutingTwoLOUser());
    }

    @Test
    public void testDefault2LOParametersAreAppropriateIfLeftUntouched() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertFalse((boolean)savedConsumer.getTwoLOAllowed());
        Assert.assertNull((Object)savedConsumer.getExecutingTwoLOUser());
        Assert.assertFalse((boolean)savedConsumer.getTwoLOImpersonationAllowed());
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreOAuth2LOImpersonationConfiguration() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).twoLOImpersonationAllowed(true).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertTrue((boolean)savedConsumer.getTwoLOImpersonationAllowed());
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreCanHandle2LOConfigurationChanges() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).twoLOAllowed(true).executingTwoLOUser("2lo_user").twoLOImpersonationAllowed(true).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertTrue((boolean)savedConsumer.getTwoLOAllowed());
        Assert.assertTrue((boolean)savedConsumer.getTwoLOImpersonationAllowed());
        Consumer consumer2 = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).twoLOAllowed(false).executingTwoLOUser("2lo_user_changed").twoLOImpersonationAllowed(false).build();
        this.consumerStore.put(consumer2);
        Consumer savedConsumer2 = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertEquals((Object)CONSUMER_KEY, (Object)savedConsumer2.getKey());
        Assert.assertFalse((boolean)savedConsumer2.getTwoLOAllowed());
        Assert.assertEquals((Object)"2lo_user_changed", (Object)savedConsumer2.getExecutingTwoLOUser());
        Assert.assertFalse((boolean)savedConsumer2.getTwoLOImpersonationAllowed());
    }

    @Test
    public void testIfConsumerDoesNotHave3LOFlagDefinedThenItIsConsideredOn() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertTrue((boolean)savedConsumer.getThreeLOAllowed());
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreOAuth3LOConfiguration() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).threeLOAllowed(false).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertFalse((boolean)savedConsumer.getThreeLOAllowed());
    }

    @Test
    public void testServiceProviderConsumerStoreCanHandle3LOConfigurationChanges() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).threeLOAllowed(false).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertFalse((boolean)savedConsumer.getThreeLOAllowed());
        Consumer consumer2 = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).threeLOAllowed(true).build();
        this.consumerStore.put(consumer2);
        Consumer savedConsumer2 = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertTrue((boolean)savedConsumer2.getThreeLOAllowed());
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreConsumerWith2LOEnabledIndependently() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).threeLOAllowed(false).twoLOAllowed(true).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertFalse((boolean)savedConsumer.getThreeLOAllowed());
        Assert.assertTrue((boolean)savedConsumer.getTwoLOAllowed());
        Assert.assertFalse((boolean)savedConsumer.getTwoLOImpersonationAllowed());
    }

    @Test
    public void testServiceProviderConsumerStoreCanStoreConsumerWith2LOWithImpersonationEnabledIndependently() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer consumer = Consumer.key((String)CONSUMER_KEY).name("Test Consumer Name").publicKey(publicKey).description("Consumer Description").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback1")).threeLOAllowed(false).twoLOImpersonationAllowed(true).build();
        this.consumerStore.put(consumer);
        Consumer savedConsumer = this.consumerStore.get(CONSUMER_KEY);
        Assert.assertFalse((boolean)savedConsumer.getThreeLOAllowed());
        Assert.assertFalse((boolean)savedConsumer.getTwoLOAllowed());
        Assert.assertTrue((boolean)savedConsumer.getTwoLOImpersonationAllowed());
    }

    @After
    public void tearDown() {
        this.consumerStore.remove(CONSUMER_KEY);
    }
}

