/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LocaleResolverTest
extends SpringAwareTestCase {
    private LocaleResolver localeResolver;

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Test
    public void testLocaleResolverAvailable() {
        Assert.assertNotNull((String)"LocaleResolver should be available to plugins", (Object)this.localeResolver);
    }

    @Test
    public void testAtLeastOneSupportedLocales() {
        Set localeSet = this.localeResolver.getSupportedLocales();
        Assert.assertTrue((String)"LocaleResolver should return at least one supported locale", (localeSet.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetLocaleForHttpServletRequestNeverNull() {
        Assert.assertNotNull((String)"getLocale(HttpServletRequest) never returns null", (Object)this.localeResolver.getLocale((HttpServletRequest)Mockito.mock(HttpServletRequest.class)));
    }

    @Test
    public void testGetLocaleWithUserKeyNeverNull() {
        Assert.assertNotNull((String)"getLocale(UserKey) never returns null", (Object)this.localeResolver.getLocale(new UserKey("fakeuser")));
    }

    @Test
    public void testGetLocaleNeverNull() {
        Assert.assertNotNull((String)"getLocale() never returns null", (Object)this.localeResolver.getLocale());
    }
}

