/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk;

import com.atlassian.refapp.ctk.AppSpecificInfoProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DefaultAppSpecificInfoProvider
implements AppSpecificInfoProvider {
    private final UserManager userManager;

    public DefaultAppSpecificInfoProvider(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public String getAdminUsername() {
        return this.getRequiredProperty("platform.ctk.test.admin.username");
    }

    @Override
    public String getAdminPassword() {
        return this.getRequiredProperty("platform.ctk.test.admin.password");
    }

    @Override
    public String getAdminFullname() {
        return this.getRequiredProperty("platform.ctk.test.admin.fullname");
    }

    @Override
    public String getMatchingSearchTerm() {
        return System.getProperty("platform.ctk.test.search.term");
    }

    @Override
    public UserKey getAdminUserKey() {
        UserProfile userProfile = this.userManager.getUserProfile(this.getAdminUsername());
        return userProfile != null ? userProfile.getUserKey() : null;
    }

    @Override
    public Set<String> getExpectedMatchingContents() {
        String matches = System.getProperty("platform.ctk.test.search.matches");
        if (StringUtils.isNotBlank((String)matches)) {
            return ImmutableSet.copyOf((Object[])StringUtils.split((String)matches, (char)','));
        }
        return null;
    }

    @Override
    public String getValidLicense() {
        return this.getRequiredProperty("platform.ctk.test.validlicense");
    }

    private String getRequiredProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            throw new IllegalStateException("System property [" + key + "] must be supplied for platform Ctk execution.");
        }
        return value;
    }
}

