package com.atlassian.refapp.ctk.aui;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;

import javax.ws.rs.core.UriBuilder;

import com.atlassian.functest.junit.SpringAwareJUnit4ClassRunner;
import com.atlassian.sal.api.ApplicationProperties;

import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.junit.runner.RunWith;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.fail;

@RunWith(SpringAwareJUnit4ClassRunner.class)
public class AuiResourcesPresentTest
{
    private ApplicationProperties appProp;

    public void setApplicationProperties(ApplicationProperties applicationProperties)
    {
        appProp = applicationProperties;
    }

    private List<String> fetchAuiHeaderLines() throws IOException
    {
        URI uri = UriBuilder.fromUri(appProp.getBaseUrl()).path("plugins/servlet/resource-using-servlet").build();

        Reader r = new InputStreamReader(uri.toURL().openStream(), "utf-8");

        return IOUtils.readLines(r);
    }

    private static void assertContainsLineMatchingRegexp(Iterable<String> lines, String regex)
    {
        Pattern p = Pattern.compile(regex);

        for (String s : lines)
        {
            if (p.matcher(s).matches())
            {
                return;
            }
        }

        fail("Expected a collection including a line matching '" + regex + "' but was: " + lines);
    }

    @Test
    public void auiProvidesResources() throws IOException
    {
        assertFalse(fetchAuiHeaderLines().isEmpty());
    }

    @Test
    public void auiResourcesIncludeCss() throws IOException
    {
        assertContainsLineMatchingRegexp(fetchAuiHeaderLines(), "<link type=.text/css. rel=.stylesheet. href=.*\\.css.*");
    }

    @Test
    public void auiResourcesIncludeJavaScript() throws IOException
    {
        assertContainsLineMatchingRegexp(fetchAuiHeaderLines(), "<script type=.text/javascript. src=.*\\.js.*");
    }
}
