package com.atlassian.refapp.ctk;

import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.EventSerializationException;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import com.atlassian.webhooks.spi.provider.WebHookRegistrar;

public final class WebHookTestProvider implements WebHookProvider
{
    @Override
    public void provide(WebHookRegistrar registrar)
    {
        registrar.webhook("test_event")
                .whenFired(WebHookTestEvent.class)
                .matchedBy(EventMatcher.ALWAYS_TRUE)
                .serializedWith(new EventSerializerFactory()
                {
                    @Override
                    public EventSerializer create(final Object event)
                    {
                        return new EventSerializer()
                        {
                            @Override
                            public Object getEvent()
                            {
                                return event;
                            }

                            @Override
                            public String getWebHookBody() throws EventSerializationException
                            {
                                return "{ \"value\": \"" + ((WebHookTestEvent) event).value + "\"}";
                            }
                        };
                    }
                });
    }
}
