/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.aui;

import com.atlassian.functest.junit.SpringAwareJUnit4ClassRunner;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SpringAwareJUnit4ClassRunner.class)
public class AuiResourcesPresentTest {
    private ApplicationProperties appProp;

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.appProp = applicationProperties;
    }

    private List<String> fetchAuiHeaderLines() throws IOException {
        URI uri = UriBuilder.fromUri((String)this.appProp.getBaseUrl()).path("plugins/servlet/resource-using-servlet").build(new Object[0]);
        InputStreamReader r = new InputStreamReader(uri.toURL().openStream(), "utf-8");
        return IOUtils.readLines((Reader)r);
    }

    private static void assertContainsLineMatchingRegexp(Iterable<String> lines, String regex) {
        Pattern p = Pattern.compile(regex);
        for (String s : lines) {
            if (!p.matcher(s).matches()) continue;
            return;
        }
        Assert.fail((String)("Expected a collection including a line matching '" + regex + "' but was: " + lines));
    }

    @Test
    public void auiProvidesResources() throws IOException {
        Assert.assertFalse((boolean)this.fetchAuiHeaderLines().isEmpty());
    }

    @Test
    public void auiResourcesIncludeCss() throws IOException {
        AuiResourcesPresentTest.assertContainsLineMatchingRegexp(this.fetchAuiHeaderLines(), "<link type=.text/css. rel=.stylesheet. href=.*\\.css.*");
    }

    @Test
    public void auiResourcesIncludeJavaScript() throws IOException {
        AuiResourcesPresentTest.assertContainsLineMatchingRegexp(this.fetchAuiHeaderLines(), "<script type=.text/javascript. src=.*\\.js.*");
    }
}

