/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.impl;

import com.atlassian.confluence.plugins.cql.spi.functions.CQLEvaluationContext;
import com.atlassian.querylang.antlrgen.AqlBaseVisitor;
import com.atlassian.querylang.antlrgen.AqlParser;
import com.atlassian.querylang.functions.EvaluationContext;
import com.atlassian.querylang.lib.functions.FunctionRegistry;
import com.atlassian.querylang.literals.StringLiteralHelper;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;

public class CQLStringValueParseTreeVisitor
extends AqlBaseVisitor<String> {
    private final FunctionRegistry functionRegistry;
    private final CQLEvaluationContext evaluationContext;

    public CQLStringValueParseTreeVisitor(FunctionRegistry functionRegistry, CQLEvaluationContext evaluationContext) {
        this.functionRegistry = functionRegistry;
        this.evaluationContext = evaluationContext;
    }

    public String visitTextOperand(@NotNull AqlParser.TextOperandContext ctx) {
        return StringLiteralHelper.stripQuotes((String)ctx.getText());
    }

    public String visitSingleValueFunctionOperand(@NotNull AqlParser.SingleValueFunctionOperandContext ctx) {
        if (this.evaluationContext != null) {
            return this.functionRegistry.getRegisteredSingleValueFunction(ctx.funcName.getText(), ctx.params.size()).invoke(this.extractParameterValues(ctx.params), (EvaluationContext)this.evaluationContext);
        }
        return null;
    }

    public String visitNumericOperand(@NotNull AqlParser.NumericOperandContext ctx) {
        return ctx.getText();
    }

    private List<String> extractParameterValues(List<AqlParser.ValueContext> parameters) {
        return Lists.transform(parameters, (Function)new Function<AqlParser.ValueContext, String>(){

            public String apply(AqlParser.ValueContext parameter) {
                return (String)CQLStringValueParseTreeVisitor.this.visitValue(parameter);
            }
        });
    }

    public String visitDateTimeOperand(@NotNull AqlParser.DateTimeOperandContext ctx) {
        return StringLiteralHelper.stripQuotes((String)ctx.getText());
    }
}

