/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.fields.expressiondata;

import com.atlassian.querylang.antlrgen.AqlParser;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.RangeExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.atlassian.querylang.fields.expressiondata.TextExpressionData;
import org.springframework.stereotype.Component;

@Component
public class ExpressionDataFactory {
    public EqualityExpressionData create(String fieldName, AqlParser.EqOpContext opContext) {
        EqualityExpressionData.Operator operator;
        if (opContext.OP_EQUALS() != null) {
            operator = EqualityExpressionData.Operator.EQUALS;
        } else if (opContext.OP_NOT_EQUALS() != null) {
            operator = EqualityExpressionData.Operator.NOT_EQUALS;
        } else {
            throw this.throwExceptionForUnknownOp((Object)opContext);
        }
        return new EqualityExpressionData(fieldName, operator);
    }

    public SetExpressionData create(String fieldName, AqlParser.SetOpContext opContext) {
        SetExpressionData.Operator operator;
        if (opContext.K_IN() != null) {
            operator = opContext.not() != null ? SetExpressionData.Operator.NOT_IN : SetExpressionData.Operator.IN;
        } else {
            throw this.throwExceptionForUnknownOp((Object)opContext);
        }
        return new SetExpressionData(fieldName, operator);
    }

    public RangeExpressionData create(String fieldName, AqlParser.RangeOpContext opContext) {
        RangeExpressionData.Operator operator;
        if (opContext.OP_GT() != null) {
            operator = RangeExpressionData.Operator.GREATER;
        } else if (opContext.OP_GTEQ() != null) {
            operator = RangeExpressionData.Operator.GREATER_OR_EQUALS;
        } else if (opContext.OP_LT() != null) {
            operator = RangeExpressionData.Operator.LESS;
        } else if (opContext.OP_LTEQ() != null) {
            operator = RangeExpressionData.Operator.LESS_OR_EQUALS;
        } else if (opContext.OP_EQUALS() != null) {
            operator = RangeExpressionData.Operator.EQUALS;
        } else if (opContext.OP_NOT_EQUALS() != null) {
            operator = RangeExpressionData.Operator.NOT_EQUALS;
        } else {
            throw this.throwExceptionForUnknownOp((Object)opContext);
        }
        return new RangeExpressionData(fieldName, operator);
    }

    public TextExpressionData create(String fieldName, AqlParser.TextOpContext opContext) {
        TextExpressionData.Operator operator;
        if (opContext.OP_LIKE() != null) {
            operator = TextExpressionData.Operator.CONTAINS;
        } else if (opContext.OP_NOT_LIKE() != null) {
            operator = TextExpressionData.Operator.NOT_CONTAINS;
        } else {
            throw this.throwExceptionForUnknownOp((Object)opContext);
        }
        return new TextExpressionData(fieldName, operator);
    }

    private RuntimeException throwExceptionForUnknownOp(Object opContext) {
        throw new IllegalArgumentException("Unknown operator type: " + opContext);
    }
}

