/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.fields;

import com.atlassian.querylang.fields.DateTimeFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.FieldHandler;
import com.atlassian.querylang.fields.NumericFieldHandler;
import com.atlassian.querylang.fields.SubfieldHandlerProvider;
import com.atlassian.querylang.fields.TextFieldHandler;
import com.atlassian.querylang.lib.fields.MapFieldHandler;
import com.atlassian.querylang.query.SearchQuery;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FieldRegistry {
    public static final List<String> TEXT_OPERATORS = Collections.unmodifiableList(Arrays.asList("~", "!~"));
    public static final List<String> EQUALITY_OPERATORS = Collections.unmodifiableList(Arrays.asList("=", "!=", "IN", "NOT IN"));
    public static final List<String> RANGE_OPERATORS = Collections.unmodifiableList(Arrays.asList("<", "<=", ">", ">=", "=", "!="));
    private final ImmutableMap<String, TextFieldHandler> textFields;
    private final ImmutableMap<String, EqualityFieldHandler> entityFields;
    private final ImmutableMap<String, NumericFieldHandler> numericFields;
    private final ImmutableMap<String, DateTimeFieldHandler> dateTimeFields;
    private final ImmutableMap<String, MapFieldHandler> mapFields;
    private final ImmutableMap<String, FieldHandler> orderByFields;
    private final Iterable<ImmutableMap<String, ? extends FieldHandler>> fieldRegistryMaps;

    protected FieldRegistry(FieldRegistryBuilder builder) {
        this.textFields = builder.textFields.build();
        this.entityFields = builder.entityFields.build();
        this.numericFields = builder.numericFields.build();
        this.dateTimeFields = builder.dateTimeFields.build();
        this.mapFields = builder.mapFields.build();
        this.orderByFields = builder.orderByFields.build();
        this.fieldRegistryMaps = Collections.unmodifiableList(Arrays.asList(this.textFields, this.entityFields, this.numericFields, this.dateTimeFields, this.mapFields, this.orderByFields));
    }

    public static FieldRegistryBuilder builder() {
        return new FieldRegistryBuilder();
    }

    public static List<String> getTextOperators() {
        return TEXT_OPERATORS;
    }

    public static List<String> getEqualityOperators() {
        return EQUALITY_OPERATORS;
    }

    public static List<String> getRangeOperators() {
        return RANGE_OPERATORS;
    }

    public boolean isRegisteredField(String field) {
        for (Map map : this.fieldRegistryMaps) {
            if (!map.containsKey(field)) continue;
            return true;
        }
        return false;
    }

    public boolean isRegisteredTextField(String field) {
        return this.textFields.containsKey((Object)field);
    }

    public TextFieldHandler getTextFieldHandler(String field) {
        this.validateRegisteredField(this.isRegisteredTextField(field), field, "text");
        return (TextFieldHandler)this.textFields.get((Object)field);
    }

    public boolean isRegisteredEqualityField(String field) {
        return this.entityFields.containsKey((Object)field);
    }

    public EqualityFieldHandler getEqualityFieldHandler(String field) {
        this.validateRegisteredField(this.isRegisteredEqualityField(field), field, "equality");
        return (EqualityFieldHandler)this.entityFields.get((Object)field);
    }

    public boolean isRegisteredNumericField(String field) {
        return this.numericFields.containsKey((Object)field);
    }

    public boolean isRegisteredDateTimeField(String field) {
        return this.dateTimeFields.containsKey((Object)field);
    }

    public DateTimeFieldHandler getDateTimeFieldHandler(String field) {
        this.validateRegisteredField(this.isRegisteredDateTimeField(field), field, "date");
        return (DateTimeFieldHandler)this.dateTimeFields.get((Object)field);
    }

    public NumericFieldHandler<? extends SearchQuery> getNumberFieldHandler(String field) {
        this.validateRegisteredField(this.isRegisteredNumericField(field), field, "number");
        return (NumericFieldHandler)this.numericFields.get((Object)field);
    }

    public boolean isRegisteredMapField(String field) {
        return this.mapFields.containsKey((Object)field);
    }

    public MapFieldHandler getMapFieldHandler(String field) {
        this.validateRegisteredField(this.isRegisteredMapField(field), field, "map");
        return (MapFieldHandler)this.mapFields.get((Object)field);
    }

    public boolean isRegisteredOrderByField(String field) {
        return this.orderByFields.containsKey((Object)field);
    }

    public FieldHandler getOrderByFieldHandler(String field) {
        this.validateRegisteredField(this.isRegisteredOrderByField(field), field, "order by");
        return (FieldHandler)this.orderByFields.get((Object)field);
    }

    private void validateRegisteredField(boolean isRegisteredField, String fieldName, String fieldType) {
        if (!isRegisteredField) {
            throw new IllegalArgumentException("No such " + fieldType + " field registered : " + fieldName);
        }
    }

    public Iterable<String> getSupportedOperators(String field) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.isRegisteredTextField(field)) {
            builder.addAll(TEXT_OPERATORS);
        }
        if (this.isRegisteredEqualityField(field)) {
            builder.addAll(EQUALITY_OPERATORS);
        }
        if (this.isRegisteredNumericField(field)) {
            builder.addAll(RANGE_OPERATORS);
        }
        if (this.isRegisteredDateTimeField(field)) {
            builder.addAll(RANGE_OPERATORS);
        }
        return builder.build();
    }

    public Iterable<TextFieldHandler> getTextFieldHandlers() {
        return this.textFields.values();
    }

    public Iterable<EqualityFieldHandler> getEqualityFieldHandlers() {
        return this.entityFields.values();
    }

    public Iterable<DateTimeFieldHandler> getDateFieldHandlers() {
        return this.dateTimeFields.values();
    }

    public Iterable<NumericFieldHandler> getNumericFieldHandlers() {
        return this.numericFields.values();
    }

    public Iterable<String> getRegisteredFieldNames() {
        HashSet keys = Sets.newHashSet();
        for (ImmutableMap<String, ? extends FieldHandler> map : this.fieldRegistryMaps) {
            keys.addAll(map.keySet());
        }
        return keys;
    }

    public static class FieldRegistryBuilder {
        private final ImmutableSortedMap.Builder<String, TextFieldHandler> textFields = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        private final ImmutableSortedMap.Builder<String, EqualityFieldHandler> entityFields = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        private final ImmutableSortedMap.Builder<String, NumericFieldHandler> numericFields = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        private final ImmutableSortedMap.Builder<String, DateTimeFieldHandler> dateTimeFields = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        private final ImmutableSortedMap.Builder<String, MapFieldHandler> mapFields = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        private final ImmutableSortedMap.Builder<String, FieldHandler> orderByFields = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);

        public FieldRegistry build() {
            return new FieldRegistry(this);
        }

        public FieldRegistryBuilder register(FieldHandler handler) {
            String fieldName = handler.fieldName();
            boolean registered = false;
            if (handler instanceof TextFieldHandler) {
                this.textFields.put((Object)fieldName, (Object)((TextFieldHandler)handler));
                registered = true;
            }
            if (handler instanceof EqualityFieldHandler) {
                this.entityFields.put((Object)fieldName, (Object)((EqualityFieldHandler)handler));
                registered = true;
            }
            if (handler instanceof DateTimeFieldHandler) {
                this.dateTimeFields.put((Object)fieldName, (Object)((DateTimeFieldHandler)handler));
                registered = true;
            }
            if (handler instanceof MapFieldHandler) {
                MapFieldHandler mapFieldHandler = (MapFieldHandler)handler;
                this.mapFields.put((Object)fieldName, (Object)mapFieldHandler);
                this.registerFields(mapFieldHandler.getAliasHandlers());
                registered = true;
            }
            if (handler instanceof NumericFieldHandler) {
                this.numericFields.put((Object)fieldName, (Object)((NumericFieldHandler)handler));
                registered = true;
            }
            if (handler.isOrderSupported()) {
                this.orderByFields.put((Object)fieldName, (Object)handler);
                registered = true;
            }
            if (handler instanceof SubfieldHandlerProvider && this.registerSubfields(handler.fieldName(), (SubfieldHandlerProvider)handler)) {
                registered = true;
            }
            if (!registered) {
                throw new IllegalArgumentException("register called but could not register handler " + handler.getClass());
            }
            return this;
        }

        private boolean registerSubfields(String parentFieldName, SubfieldHandlerProvider handler) {
            boolean registered = false;
            for (FieldHandler subFieldHandler : handler.getSubfieldHandlers()) {
                this.register(this.createSubFieldHandlerProxy(parentFieldName, subFieldHandler));
                registered = true;
            }
            return registered;
        }

        private boolean registerFields(Iterable<? extends FieldHandler> handlers) {
            boolean registered = false;
            for (FieldHandler fieldHandler : handlers) {
                this.register(fieldHandler);
                registered = true;
            }
            return registered;
        }

        @VisibleForTesting
        public FieldHandler createSubFieldHandlerProxy(String parentFieldName, FieldHandler handlerToProxy) {
            String fullSubFieldName = String.format("%s.%s", parentFieldName, handlerToProxy.fieldName());
            ArrayList interfacesExtendingFieldHandler = Lists.newArrayList();
            for (Class<?> iface : handlerToProxy.getClass().getInterfaces()) {
                if (!FieldHandler.class.isAssignableFrom(iface)) continue;
                interfacesExtendingFieldHandler.add(iface);
            }
            return (FieldHandler)Proxy.newProxyInstance(handlerToProxy.getClass().getClassLoader(), interfacesExtendingFieldHandler.toArray(new Class[interfacesExtendingFieldHandler.size()]), (proxy, method, args) -> {
                if (method.getName().equals("toString")) {
                    return String.format("SubFieldHandlerProxy, parentField: %s , proxying : %s", parentFieldName, method.invoke((Object)handlerToProxy, new Object[0]));
                }
                if (method.getName().equals("fieldName")) {
                    return fullSubFieldName;
                }
                return method.invoke((Object)handlerToProxy, args);
            });
        }
    }
}

