/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.dropwizard;

import com.atlassian.util.profiling.MetricsConfiguration;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class DropwizardMetricStrategy
implements MetricStrategy {
    private static final int DEFAULT_RESERVOIR_SIZE = 2048;
    private static final int DEFAULT_MAX_NUMBER_OF_METRICS = 128;
    private final int maxNumberOfMetrics;
    private final MetricRegistry registry;
    private final int reservoirSize;

    public DropwizardMetricStrategy(@Nonnull MetricRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.maxNumberOfMetrics = 128;
        this.reservoirSize = 2048;
    }

    private DropwizardMetricStrategy(Builder builder) {
        this.maxNumberOfMetrics = builder.maxNumberOfMetrics;
        this.registry = builder.registry;
        this.reservoirSize = builder.reservoirSize;
    }

    public void setConfiguration(@Nonnull MetricsConfiguration configuration) {
    }

    @Nonnull
    public Ticker startTimer(@Nonnull String metricName) {
        Timer timer = (Timer)this.registry.getTimers().get(metricName);
        if (timer == null && this.registry.getMetrics().size() < this.maxNumberOfMetrics) {
            timer = this.registry.timer(metricName, () -> new Timer((Reservoir)new ExponentiallyDecayingReservoir(this.reservoirSize, 0.015)));
        }
        if (timer == null) {
            return Ticker.NO_OP;
        }
        Timer.Context context = timer.time();
        return () -> ((Timer.Context)context).close();
    }

    public void updateHistogram(@Nonnull String metricName, long value) {
        Histogram histogram = (Histogram)this.registry.getHistograms().get(metricName);
        if (histogram == null && this.registry.getMetrics().size() < this.maxNumberOfMetrics) {
            histogram = this.registry.histogram(metricName, () -> new Histogram((Reservoir)new ExponentiallyDecayingReservoir(this.reservoirSize, 0.015)));
        }
        if (histogram != null) {
            histogram.update(value);
        }
    }

    public void updateTimer(@Nonnull String metricName, long time, @Nonnull TimeUnit timeUnit) {
        this.registry.timer(metricName).update(time, timeUnit);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private int maxNumberOfMetrics;
        private int reservoirSize;

        public Builder(@Nonnull MetricRegistry registry) {
            this.registry = Objects.requireNonNull(registry, "registry");
            this.maxNumberOfMetrics = 128;
            this.reservoirSize = 2048;
        }

        @Nonnull
        public DropwizardMetricStrategy build() {
            return new DropwizardMetricStrategy(this);
        }

        @Nonnull
        public Builder maxNumberOfMetrics(int value) {
            this.maxNumberOfMetrics = value;
            return this;
        }

        @Nonnull
        public Builder reservoirSize(int value) {
            this.reservoirSize = value;
            return this;
        }
    }
}

