/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.featureflags.descriptor;

import com.atlassian.fugue.Option;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.pocketknife.api.featureflags.FeatureFlag;
import com.atlassian.pocketknife.internal.featureflags.descriptor.FeatureFlagParser;
import com.atlassian.pocketknife.spi.featureflags.FeatureFlagProvider;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class FeatureFlagModuleDescriptor
extends AbstractModuleDescriptor<FeatureFlagProvider> {
    private static final Set<FeatureFlag> EMPTY_FLAGS = Collections.emptySet();
    private Set<FeatureFlag> staticDescriptorFlags = EMPTY_FLAGS;
    private final ResettableLazyReference<Option<FeatureFlagProvider>> moduleRef = new ResettableLazyReference<Option<FeatureFlagProvider>>(){

        protected Option<FeatureFlagProvider> create() throws Exception {
            return SafePluginPointAccess.call((Callable)new Callable<FeatureFlagProvider>(){

                @Override
                public FeatureFlagProvider call() throws Exception {
                    if (StringUtils.isEmpty((String)FeatureFlagModuleDescriptor.this.moduleClassName)) {
                        return null;
                    }
                    return (FeatureFlagProvider)FeatureFlagModuleDescriptor.this.moduleFactory.createModule(FeatureFlagModuleDescriptor.this.moduleClassName, (ModuleDescriptor)FeatureFlagModuleDescriptor.this);
                }
            });
        }
    };

    @Autowired
    public FeatureFlagModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.staticDescriptorFlags = FeatureFlagParser.parseFlags(element);
    }

    public FeatureFlagProvider getModule() {
        return (FeatureFlagProvider)((Option)this.moduleRef.get()).getOrNull();
    }

    public Set<FeatureFlag> getFeatureFlags() {
        Option moduleFlags = SafePluginPointAccess.call((Callable)new Callable<Set<FeatureFlag>>(){

            @Override
            public Set<FeatureFlag> call() throws Exception {
                Option provider = Option.option((Object)FeatureFlagModuleDescriptor.this.getModule());
                if (provider.isDefined()) {
                    return (Set)Option.option((Object)((FeatureFlagProvider)provider.get()).getFeatureFlags()).getOrElse((Object)EMPTY_FLAGS);
                }
                return EMPTY_FLAGS;
            }
        });
        HashSet flags = Sets.newHashSet();
        flags.addAll(this.staticDescriptorFlags);
        flags.addAll((Collection)moduleFlags.getOrElse(EMPTY_FLAGS));
        return flags;
    }
}

