/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.featureflags;

import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.featureflags.FeatureFlag;
import com.atlassian.pocketknife.api.featureflags.FeatureFlagManager;
import com.atlassian.pocketknife.internal.featureflags.FeatureFlagProviderAccessor;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class DefaultFeatureFlagManager
implements FeatureFlagManager {
    private final FeatureFlagProviderAccessor featureFlagProviderAccessor;
    private final FeatureManager featureManager;

    @Autowired
    public DefaultFeatureFlagManager(FeatureFlagProviderAccessor featureFlagProviderAccessor, FeatureManager featureManager) {
        this.featureFlagProviderAccessor = featureFlagProviderAccessor;
        this.featureManager = featureManager;
    }

    public Set<FeatureFlag> getRegisteredFlags() {
        return this.featureFlagProviderAccessor.getFeatureFlags();
    }

    public Option<FeatureFlag> getFeatureFlag(String featureKey) {
        return this.findFeatureFlag(featureKey);
    }

    public boolean isEnabled(FeatureFlag featureFlag) {
        if (featureFlag.isOnByDefault()) {
            return !this.featureManager.isEnabled(featureFlag.disabledFeatureKey());
        }
        return this.featureManager.isEnabled(featureFlag.enabledFeatureKey());
    }

    public boolean isEnabled(String featureKey) {
        Option<FeatureFlag> featureFlagOption = this.findFeatureFlag(featureKey);
        if (featureFlagOption.isDefined()) {
            return this.isEnabled((FeatureFlag)featureFlagOption.get());
        }
        return this.isEnabled(FeatureFlag.featureFlag((String)featureKey).offByDefault());
    }

    Option<FeatureFlag> findFeatureFlag(String featureKey) {
        Set<FeatureFlag> flags = this.featureFlagProviderAccessor.getFeatureFlags();
        for (FeatureFlag flag : flags) {
            if (!flag.getFeatureKey().equals(featureKey)) continue;
            return Option.some((Object)flag);
        }
        return Option.none();
    }
}

