/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.test;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.dom4j.Element;
import org.dom4j.util.NodeComparator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;

public class Matchers {
    public static Matcher<File> fileNamed(final String name) {
        return new TypeSafeMatcher<File>(){
            private final Matcher<String> nameMatcher;
            {
                this.nameMatcher = org.hamcrest.Matchers.equalTo((Object)name);
            }

            protected boolean matchesSafely(File item) {
                return this.nameMatcher.matches((Object)item.getName());
            }

            public void describeTo(Description description) {
                description.appendText("File named ");
                this.nameMatcher.describeTo(description);
            }
        };
    }

    public static Matcher<URI> uriWithPath(final String path) {
        return new TypeSafeMatcher<URI>(){
            private final Matcher<String> pathMatcher;
            {
                this.pathMatcher = org.hamcrest.Matchers.equalTo((Object)path);
            }

            protected boolean matchesSafely(URI item) {
                File f = new File(item);
                return this.pathMatcher.matches((Object)f.getPath());
            }

            public void describeTo(Description description) {
                description.appendText("URI with path ");
                this.pathMatcher.describeTo(description);
            }
        };
    }

    static Matcher<String> containsAllStrings(String ... substrings) {
        Matcher[] matchers = (Matcher[])StreamSupport.stream(Arrays.spliterator(substrings), false).map(org.hamcrest.Matchers::containsString).toArray(Matcher[]::new);
        return CoreMatchers.allOf((Matcher[])matchers);
    }

    public static Matcher<Element> isElement(final Element expected) {
        return new TypeSafeMatcher<Element>(){

            protected boolean matchesSafely(Element item) {
                return new NodeComparator().compare(expected, item) == 0;
            }

            public void describeTo(Description description) {
                description.appendText("is ").appendText(expected.toString());
            }
        };
    }

    public static <T> Matcher<Optional<T>> isPresent() {
        return new FeatureMatcher<Optional<T>, Boolean>(Is.is((Object)true), "an Optional whose isPresent", "isPresent"){

            protected Boolean featureValueOf(Optional<T> optional) {
                return optional.isPresent();
            }
        };
    }

    public static <T> Matcher<Optional<T>> notPresent() {
        return new FeatureMatcher<Optional<T>, Boolean>(Is.is((Object)false), "an Optional whose isPresent", "isPresent"){

            protected Boolean featureValueOf(Optional<T> optional) {
                return optional.isPresent();
            }
        };
    }

    public static <T> Matcher<? super Optional<T>> presentWithValue(final Matcher<T> valueMatcher) {
        return new TypeSafeMatcher<Optional<T>>(){

            protected boolean matchesSafely(Optional<T> optional) {
                return optional.isPresent() && valueMatcher.matches(optional.get());
            }

            public void describeTo(Description description) {
                description.appendText("a present Optional whose value ");
                description.appendDescriptionOf((SelfDescribing)valueMatcher);
            }
        };
    }
}

