import React from 'react';
import ErrorIcon from '@atlaskit/icon/glyph/error';
import InfoIcon from '@atlaskit/icon/glyph/info';
import SuccessIcon from '@atlaskit/icon/glyph/check-circle';
import WarningIcon from '@atlaskit/icon/glyph/warning';
import { colors } from '@atlaskit/theme';

import {
    Content,
    Description,
    Header,
    Icon,
    MessageContainer,
    Title,
} from './health-check-card.styled';

function getIcon(appearance) {
    switch (appearance) {
        case 'success':
            return <SuccessIcon label="success" primaryColor={colors.G300} />;
        case 'warning':
            return <WarningIcon label="warning" primaryColor={colors.Y400} />;
        case 'error':
            return <ErrorIcon label="error" primaryColor={colors.R400} />;
        case 'info':
        default:
            return <InfoIcon label="info" primaryColor={colors.B300} />;
    }
}

const HealthCheckCard = ({ appearance, title, children }) => {
    return (
        <MessageContainer>
            <Header>
                <Icon>{getIcon(appearance)}</Icon>
                <Title>{title}</Title>
            </Header>
            <Content>
                <Description>{children}</Description>
            </Content>
        </MessageContainer>
    );
};

export default HealthCheckCard;
