import contextPath from 'wrm/context-path'; // eslint-disable-line

/**
 * The list of plugin keys that are reported by the deprecatedDescriptors endpoint
 *  but are known to be safe for the CDN.
 * @type {String[]}
 */
const DEPRECATED_PLUGINS_WHITELIST = [
    'com.atlassian.jira.collector.plugin.jira-issue-collector-plugin',
];

function fetchDeprecatedModules() {
    return fetch(`${contextPath()}/rest/webResources/1.0/deprecatedDescriptors`, {
        cache: 'no-cache',
    }).then(response => {
        if (response.ok) {
            return response.json();
        }
        throw new Error('Fetch failed');
    });
}

function fetchPlugin(pluginKey) {
    const url = `${contextPath()}/rest/plugins/1.0/${pluginKey}-key/summary`;
    return fetch(url, { cache: 'no-cache' }).then(response => {
        if (response.ok) {
            return response.json();
        }
        throw new Error('Fetch failed');
    });
}

export function getListOfDeprecatedPlugins() {
    return new Promise((resolve, reject) => {
        fetchDeprecatedModules()
            .then(data => {
                const pluginKeys = (data.webresources || []).map(wr =>
                    wr.moduleKey.substr(0, wr.moduleKey.indexOf(':'))
                );
                const uniquePluginKeys = Array.from(new Set(pluginKeys)).filter(
                    pluginKey => pluginKey && !DEPRECATED_PLUGINS_WHITELIST.includes(pluginKey)
                );
                Promise.all(uniquePluginKeys.map(pluginKey => fetchPlugin(pluginKey)))
                    .then(plugins => resolve(plugins))
                    .catch(e => reject(e));
            })
            .catch(e => reject(e));
    });
}
