export function restoreFetch() {
    if (jest.isMockFunction(global.fetch)) {
        global.fetch.mockRestore();
    }
}

export function mockFetch() {
    if (!global.fetch) {
        global.fetch = jest.fn();
    } else if (!jest.isMockFunction(global.fetch)) {
        jest.spyOn(global, 'fetch');
    }
    return global.fetch;
}

export function mockFetchSuccess(jsonResponse, statusOk = true) {
    return mockFetch().mockResolvedValueOnce({
        ok: statusOk,
        json: () => Promise.resolve(jsonResponse),
    });
}

export function mockFetchFailure(error) {
    return mockFetch().mockRejectedValueOnce(error);
}
