import 'wr-dependency!com.atlassian.auiplugin:aui-spinner'; // eslint-disable-line
import runOnDCL from 'shims/run-on-dcl';

import 'cdn-admin-init.css';

function init() {
    import(/* webpackChunkName: "admin-config-init" */ 'admin-config/admin-config-init').then(
        ({ default: initAdminConfigPage }) => {
            const container = document.getElementById('cdn-admin-content');
            initAdminConfigPage(container);
        }
    );
}

runOnDCL(() => {
    init();
});

if (module.hot) {
    module.hot.accept('admin-config/admin-config-init.js', () => {
        console.info('Accepting the updated admin-config module!');
        init();
    });
}
