import React, { useEffect, useState } from 'react';
import Spinner from '@atlaskit/spinner';

import helpPaths from 'help-paths';
import formatter from 'shims/i18n';
import LearnMore from 'admin-config/learn-more/learn-more';
import { MetricDesc, MetricValue } from './latency-metric.styled';
import { getNetworkOverheadMetric } from './latency-metric-service';

const LatencyMetric = () => {
    const [latency, setLatency] = useState(<Spinner size="medium" />);

    function refreshPerfMetrics() {
        getNetworkOverheadMetric().then(metric => setLatency(metric));
    }

    useEffect(() => {
        refreshPerfMetrics();
    }, []);

    return (
        <>
            <section>
                <h3>{formatter.I18n.getText('static.assets.admin.performance.metric.latency')}</h3>
                <div>
                    <MetricValue>
                        {latency}
                        <sup>%</sup>
                    </MetricValue>
                    <MetricDesc>
                        {formatter.I18n.getText(
                            'static.assets.admin.performance.metric.latency.desc'
                        )}{' '}
                        <LearnMore url={helpPaths.getLatencyMetricDocURL()} />
                    </MetricDesc>
                </div>
            </section>
        </>
    );
};

export default LatencyMetric;
