/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.search.feed;

import com.atlassian.plugins.search.SearchResultsMarshaller;
import com.atlassian.plugins.util.XMLUtil;
import com.atlassian.sal.api.search.SearchMatch;
import com.atlassian.sal.api.search.SearchResults;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;

public class RomeFeedMarshaller
implements SearchResultsMarshaller {
    private String type;
    private static final String TITLE_PATTERN = "Search results for query: {0}";
    private static final String DESCRIPTION_PATTERN = "Search results for query: {0}. Search returned {1} results in {2}ms";

    public RomeFeedMarshaller(String type) {
        this.type = type;
    }

    public void marshalTo(SearchResults searchResults, String baseUrl, String query, Writer writer) throws IOException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(this.type);
        feed.setLink(baseUrl);
        feed.setTitle(MessageFormat.format(TITLE_PATTERN, query));
        feed.setDescription(MessageFormat.format(DESCRIPTION_PATTERN, query, searchResults.getTotalResults(), searchResults.getSearchTime()));
        feed.setEntries(Lists.transform((List)searchResults.getMatches(), (Function)new ResultToFeedItemTransformer()));
        try {
            new SyndFeedOutput().output((SyndFeed)feed, writer);
        }
        catch (FeedException fe) {
            throw new IOException("Failed to create feed", fe);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultToFeedItemTransformer
    implements Function<SearchMatch, SyndEntry> {
        private ResultToFeedItemTransformer() {
        }

        public SyndEntry apply(SearchMatch match) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(match.getTitle());
            entry.setLink(match.getUrl());
            SyndContentImpl content = new SyndContentImpl();
            content.setType("text/plain");
            content.setValue(XMLUtil.replaceInvalidXmlCharacters(match.getExcerpt()));
            entry.setDescription((SyndContent)content);
            return entry;
        }
    }
}

