/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.sal;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugins.rest.v2.ChainingClassLoader;
import com.atlassian.plugins.rest.v2.sal.MarshallingEntityHandler;
import com.atlassian.plugins.rest.v2.sal.MarshallingRequest;
import com.atlassian.plugins.rest.v2.util.ContextClassLoaderSwitchingProxy;
import com.atlassian.sal.api.net.MarshallingRequestFactory;
import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import io.atlassian.util.concurrent.LazyReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class DefaultMarshallingRequestFactory
implements MarshallingRequestFactory {
    private final RequestFactory<? extends Request> delegateRequestFactory;
    private final Plugin plugin;
    private final LazyReference<MarshallingEntityHandler> marshallingEntityHandlerReference = new LazyReference<MarshallingEntityHandler>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MarshallingEntityHandler create() {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ChainingClassLoader chainingClassLoader = DefaultMarshallingRequestFactory.this.getChainingClassLoader(DefaultMarshallingRequestFactory.this.plugin);
            try {
                Thread.currentThread().setContextClassLoader(chainingClassLoader);
                MarshallingEntityHandler marshallingEntityHandler = new MarshallingEntityHandler((OsgiPlugin)DefaultMarshallingRequestFactory.this.plugin);
                return marshallingEntityHandler;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    };

    public DefaultMarshallingRequestFactory(NonMarshallingRequestFactory<? extends Request> delegateRequestFactory, Plugin plugin) {
        this.plugin = plugin;
        this.delegateRequestFactory = delegateRequestFactory;
    }

    public Request createRequest(Request.MethodType methodType, String s) {
        Request delegateRequest = this.delegateRequestFactory.createRequest(methodType, s);
        MarshallingRequest request = new MarshallingRequest(delegateRequest, (MarshallingEntityHandler)this.marshallingEntityHandlerReference.get(), this.plugin);
        return (Request)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Request.class}, (InvocationHandler)new ContextClassLoaderSwitchingProxy(request, this.getChainingClassLoader(this.plugin)));
    }

    public boolean supportsHeader() {
        return this.delegateRequestFactory.supportsHeader();
    }

    private ChainingClassLoader getChainingClassLoader(Plugin plugin) {
        return new ChainingClassLoader(this.getClass().getClassLoader(), plugin.getClassLoader());
    }
}

