/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.filter;

import com.atlassian.plugins.rest.api.deprecation.annotation.DeprecatedEndpoint;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DeprecationFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(DeprecationFilter.class);
    private static final Map<String, String> MIME_TYPE_MAP = new HashMap<String, String>();
    @Context
    private ResourceInfo resourceInfo;
    private static final String DEFAULT_DEPRECATION_DATE = "1970-01-01T00:00:00Z";

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        DeprecatedEndpoint deprecationData = this.getDeprecationData();
        if (deprecationData != null) {
            String isoDate = deprecationData.since();
            try {
                Instant instant = Instant.parse(isoDate);
                long timestamp = instant.getEpochSecond();
                responseContext.getHeaders().add((Object)"Deprecation", (Object)("@" + timestamp));
            }
            catch (DateTimeParseException e) {
                log.error("Given timestamp {} is not in correct ISO-8601 format. Hence setting the default platform 7 release date {}", (Object)isoDate, (Object)DEFAULT_DEPRECATION_DATE);
                responseContext.getHeaders().add((Object)"Deprecation", (Object)("@" + Instant.parse(DEFAULT_DEPRECATION_DATE).getEpochSecond()));
            }
            if (!deprecationData.link().isEmpty() && this.validateLink(deprecationData.link(), deprecationData.linkType())) {
                String validatedLink = deprecationData.link();
                responseContext.getHeaders().add((Object)"Link", (Object)("<" + validatedLink + ">;rel=\"deprecation\";type=\"" + deprecationData.linkType() + "\""));
            }
        }
    }

    private boolean validateLink(String link, String linkType) {
        try {
            String mimeType;
            URL url = new URL(link);
            String path = url.getPath();
            if (path == null || !path.contains(".")) {
                mimeType = "text/html";
            } else {
                String extension = this.getExtension(path);
                mimeType = MIME_TYPE_MAP.getOrDefault(extension, "text/html");
            }
            return linkType.equals(mimeType);
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL of link: {} for given linkType: {}", (Object)link, (Object)linkType);
            return false;
        }
    }

    private String getExtension(String path) {
        int lastDotIndex = path.lastIndexOf(46);
        return path.substring(lastDotIndex + 1).toLowerCase();
    }

    private DeprecatedEndpoint getDeprecationData() {
        Package resourcePackage;
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (null != resourceMethod && resourceMethod.isAnnotationPresent(DeprecatedEndpoint.class)) {
            return resourceMethod.getAnnotation(DeprecatedEndpoint.class);
        }
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (null != resourceClass && resourceClass.isAnnotationPresent(DeprecatedEndpoint.class)) {
            return resourceClass.getAnnotation(DeprecatedEndpoint.class);
        }
        if (null != resourceClass && null != (resourcePackage = this.resourceInfo.getResourceClass().getPackage()) && resourcePackage.isAnnotationPresent(DeprecatedEndpoint.class)) {
            return resourcePackage.getAnnotation(DeprecatedEndpoint.class);
        }
        return null;
    }

    static {
        MIME_TYPE_MAP.put("html", "text/html");
        MIME_TYPE_MAP.put("htm", "text/html");
        MIME_TYPE_MAP.put("md", "text/html");
        MIME_TYPE_MAP.put("pdf", "application/pdf");
        MIME_TYPE_MAP.put("txt", "text/plain");
        MIME_TYPE_MAP.put("xml", "application/xml");
        MIME_TYPE_MAP.put("json", "application/json");
    }
}

