/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.exception;

import com.atlassian.plugins.rest.v2.exception.entity.UncaughtExceptionEntity;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5000)
@Provider
public class ThrowableExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ThrowableExceptionMapper.class);
    @Context
    Request request;

    public Response toResponse(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            WebApplicationException webEx = (WebApplicationException)throwable;
            if (webEx.getResponse().getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                String errorId = UUID.randomUUID().toString();
                log.error("Internal Server Error {} in REST: {}: {}", new Object[]{errorId, webEx.getResponse().getStatus(), webEx.getResponse(), webEx});
                return Response.status((int)webEx.getResponse().getStatus()).entity((Object)new UncaughtExceptionEntity((Throwable)webEx, errorId)).type(UncaughtExceptionEntity.variantFor(this.request)).build();
            }
            log.debug("REST response: {}: {}", (Object)webEx.getResponse().getStatus(), (Object)webEx.getResponse());
            return Response.status((int)webEx.getResponse().getStatus()).entity((Object)new UncaughtExceptionEntity(webEx.getResponse().getStatus(), (Throwable)webEx)).type(UncaughtExceptionEntity.variantFor(this.request)).build();
        }
        String errorId = UUID.randomUUID().toString();
        log.error("Uncaught exception {} thrown by REST service: {}", new Object[]{errorId, throwable.getMessage(), throwable});
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new UncaughtExceptionEntity(throwable, errorId)).type(UncaughtExceptionEntity.variantFor(this.request)).build();
    }
}

