/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.exception;

import com.atlassian.plugins.rest.api.model.Status;
import com.atlassian.plugins.rest.api.security.exception.AccessDeniedException;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5000)
@Provider
public class SecurityExceptionMapper
implements ExceptionMapper<SecurityException> {
    private static final Logger log = LoggerFactory.getLogger(SecurityExceptionMapper.class);
    @Context
    Request request;

    public Response toResponse(SecurityException exception) {
        log.debug("Security Exception in REST: ", (Throwable)exception);
        if (exception instanceof AccessDeniedException) {
            return Status.fromStatusCode((int)((AccessDeniedException)exception).getHttpResponseStatusCode()).message(exception.getMessage()).responseBuilder().type(Status.variantFor((Request)this.request)).build();
        }
        return Status.unauthorized().message(exception.getMessage()).responseBuilder().type(Status.variantFor((Request)this.request)).build();
    }
}

