/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.websudo;

import com.atlassian.plugins.rest.v2.util.ServletUtils;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalWebSudoResourceContext {
    private static final Logger log = LoggerFactory.getLogger(SalWebSudoResourceContext.class);
    private static final String BASIC_AUTHZ_TYPE_PREFIX = "Basic ";
    private static final String BEARER_AUTHZ_TYPE_PREFIX = "Bearer ";
    private final WebSudoManager webSudoManager;
    private final UserManager userManager;

    public SalWebSudoResourceContext(WebSudoManager webSudoManager, UserManager userManager) {
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
    }

    public boolean shouldEnforceWebSudoProtection() {
        HttpServletRequest req = ServletUtils.getHttpServletRequest();
        if (null == req) {
            return false;
        }
        String authHeader = req.getHeader("Authorization");
        if (authHeader != null && (this.isBasicAuthValid(authHeader) || this.shouldDisableWebSudoForPersonalAccessTokens(req, authHeader))) {
            return false;
        }
        return !this.webSudoManager.canExecuteRequest(req);
    }

    private boolean shouldDisableWebSudoForPersonalAccessTokens(HttpServletRequest request, String authHeader) {
        HttpSession session = request.getSession(false);
        return Objects.nonNull(session) && authHeader.startsWith(BEARER_AUTHZ_TYPE_PREFIX) && Objects.nonNull(session.getAttribute("is.pats.enabled"));
    }

    private boolean isBasicAuthValid(String authHeader) {
        if (this.isBasicAuthorizationHeader(authHeader)) {
            Optional<UserPassCredentials> credentials = this.decodeBasicAuthorizationCredentials(authHeader);
            return credentials.map(credential -> this.validateCredentials(credential.getUsername(), credential.getPassword())).orElse(false);
        }
        return false;
    }

    private boolean isBasicAuthorizationHeader(String header) {
        return header != null && header.startsWith(BASIC_AUTHZ_TYPE_PREFIX);
    }

    private boolean validateCredentials(String username, String password) {
        return this.userManager.authenticate(username, password);
    }

    private Optional<UserPassCredentials> decodeBasicAuthorizationCredentials(String authHeader) {
        String base64Credentials = authHeader.substring(BASIC_AUTHZ_TYPE_PREFIX.length()).trim();
        try {
            String token = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            String[] values = token.split(":", 2);
            if (values.length == 2 && !values[0].isEmpty() && !values[1].isEmpty()) {
                return Optional.of(new UserPassCredentials(values[0], values[1]));
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Provided BasicAuth token that is not valid base64 string: {}", (Object)e.getMessage());
        }
        return Optional.empty();
    }

    public static class UserPassCredentials {
        private final String username;
        private final String password;

        public UserPassCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

